/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis;

import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.WSRMUtils;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.P8BPMSoapActionURI;
import filenet.ws.utils.WSLogger;
import filenet.ws.utils.att.AttachmentHelper;
import filenet.ws.utils.att.IWSAttSaver;
import filenet.ws.utils.att.IWSAttSession;
import java.io.File;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;

public class AttachmentHandler
extends BasicHandler {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis");
    protected static final String m_className = "AttachmentHandler";
    private static IWSAttSession m_gWSAttSession = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 17:33:46  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.11  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        String m_method = "invoke";
        if (msgContext.getPastPivot()) {
            return;
        }
        logger.entering(m_className, "invoke");
        try {
            if (WSRMUtils.isRMSequenceMessage(msgContext)) {
                return;
            }
            this.processAttachment(msgContext);
        }
        finally {
            logger.exiting(m_className, "invoke");
        }
    }

    private static File getP8ConfigFile(String s) {
        try {
            String m_method = "getP8ConfigFile";
            if (s == null) {
                return null;
            }
            File f = new File(s);
            File pf = f.getParentFile();
            String myFile = pf.getCanonicalPath() + File.separator + "WcmApiConfig.properties";
            File thisFile = new File(myFile);
            if (thisFile.exists()) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "getP8ConfigFile", "Use: " + myFile);
                }
                return thisFile;
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "getP8ConfigFile", "Not Exists: " + myFile);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void getWSAttSession(MessageContext msgContext) {
        if (m_gWSAttSession == null) {
            try {
                WSListenerProperties props = (WSListenerProperties)msgContext.getProperty("MC.P8BPM.LISTENERPROPERTIES");
                if (props != null) {
                    props.refresh();
                    String username = props.getUserName();
                    String password = props.getPassword();
                    String configFile = props.getFullPath();
                    if (username != null) {
                        String handlerClassName = props.getProperty("att.handler");
                        if (handlerClassName == null) {
                            handlerClassName = "filenet.vw.idm.trident.WSSession";
                        }
                        Class<?> handlerClass = Class.forName(handlerClassName);
                        m_gWSAttSession = (IWSAttSession)handlerClass.newInstance();
                        m_gWSAttSession.setCredentials(username, password, AttachmentHandler.getP8ConfigFile(configFile));
                    }
                }
            }
            catch (Throwable t) {
                m_gWSAttSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttachment(MessageContext msgContext) {
        String m_method = "processAttachment";
        logger.entering(m_className, "processAttachment");
        try {
            Message msg = msgContext.getRequestMessage();
            if (msg.countAttachments() == 0) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "processAttachment", "Message has no attachments..");
                }
                return;
            }
            WSLogger m_wsLogger = (WSLogger)msgContext.getProperty("MC.P8BPM.WSLOGGER");
            P8BPMSoapActionURI soapActionURI = (P8BPMSoapActionURI)msgContext.getProperty("MC.P8BPM.SOAPACTIONURI");
            String m_wsLibraryId = soapActionURI.getWsLibraryId();
            String m_wsFolderId = soapActionURI.getWsFolderId();
            boolean bCleanupMessage = false;
            String newInMsg = null;
            if (m_wsLibraryId == null || m_wsLibraryId.length() == 0 || m_wsFolderId == null || m_wsFolderId.length() == 0) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "processAttachment", "No Folder Id in SOAPAction, skip attachments");
                }
                if (m_wsLogger != null) {
                    m_wsLogger.print("AttachmentHandler EXIT No FolderID");
                }
                bCleanupMessage = true;
            }
            if (!bCleanupMessage) {
                AttachmentHandler.getWSAttSession(msgContext);
                if (m_gWSAttSession == null) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, "processAttachment", "No WSSession, skip attachments.");
                    }
                    if (m_wsLogger != null) {
                        m_wsLogger.print("AttachmentHandler EXIT No WS Session");
                    }
                    bCleanupMessage = true;
                }
                if (!bCleanupMessage) {
                    try {
                        IWSAttSaver saver = m_gWSAttSession.getSaver(m_wsLibraryId, m_wsFolderId);
                        String s_reply = new VWString("filenet.ws.listener.axis.AttachmentHandler.WSReply", "WS Reply").toString();
                        String s_receive = new VWString("filenet.ws.listener.axis.AttachmentHandler.WSReceive", "WS Receive").toString();
                        String titlePrefix = (soapActionURI.isReply() ? s_reply : s_receive) + " " + soapActionURI.getPortType() + " " + soapActionURI.getOperation();
                        newInMsg = AttachmentHelper.storeAttachments((SOAPMessage)msg, saver, titlePrefix, m_wsLogger);
                        bCleanupMessage = newInMsg == null;
                    }
                    catch (Exception ex) {
                        if (logger.isFinest()) {
                            logger.throwing(m_className, "processAttachment:IGNORE", ex);
                        }
                        bCleanupMessage = true;
                    }
                }
            }
            if (bCleanupMessage) {
                newInMsg = AttachmentHelper.removeAttachments((SOAPMessage)msg, m_wsLogger);
            }
            if (newInMsg != null && newInMsg.trim().length() > 0) {
                msgContext.setProperty("MC.P8BPM.INMSG", (Object)newInMsg);
            }
            if (m_wsLogger != null) {
                m_wsLogger.print("AttachmentHandler EXIT OK");
            }
        }
        catch (Throwable e) {
            if (logger.isFinest()) {
                logger.throwing(m_className, "processAttachment:IGNORE", e);
            }
        }
        finally {
            logger.exiting(m_className, "processAttachment");
        }
    }
}

